<?php

use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model bitcream\smartsignage\custom\common\models\base\Preset */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="preset-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'layout_id')->dropDownList(
                ArrayHelper::map($layouts,'id',function ($model) {
                    return $model['name'];
                })
            )->label(Yii::t('smartsignage', 'Layouts'))
            ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'name')->textInput() ?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('smartsignage', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
