<?php

namespace bitcream\smartsignage\custom\common\models;

use Yii;
use bitcream\smartsignage\custom\common\behaviors\StatusBehaviors;
use bitcream\smartsignage\custom\common\behaviors\CreateUpdateBehaviors;

/**
 * This is the model class for table "{{%image}}".
 *
 */
class Image extends base\Image
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }

    public function fields(){
        return [
            'content_type' => "contentType",
            'source',
            'fit',
        ];
    }

    public static function getContentType()
    {
        return "image";
    }
}
