<?php

namespace bitcream\smartsignage\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%layout}}".
 *
 * @property int $id
 * @property string|null $name
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property string|null $width
 * @property string|null $height
 *
 * @property LayoutZone[] $layoutZones
 * @property Preset[] $presets
 */
class Layout extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%layout}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['name', 'created_at', 'updated_at','width', 'height'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('smartsignage', 'ID'),
            'name' => Yii::t('smartsignage', 'Name'),
            'status' => Yii::t('smartsignage', 'Status'),
            'created_at' => Yii::t('smartsignage', 'Created At'),
            'created_user_id' => Yii::t('smartsignage', 'Created User ID'),
            'updated_at' => Yii::t('smartsignage', 'Updated At'),
            'updated_user_id' => Yii::t('smartsignage', 'Updated User ID'),
            'width' => Yii::t('smartsignage', 'Width'),
            'height' => Yii::t('smartsignage', 'Height'),
        ];
    }

    /**
     * Gets query for [[LayoutZones]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getLayoutZones()
    {
        return $this->hasMany(LayoutZone::className(), ['layout_id' => 'id'])->inverseOf('layout');
    }

    /**
     * Gets query for [[Presets]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPresets()
    {
        return $this->hasMany(Preset::className(), ['layout_id' => 'id'])->inverseOf('layout');
    }
}
