<?php

namespace bitcream\smartsignage\custom\common\utils;
use Yii;

/**
 * This is the class for create menu left
 */
class Menu
{

    public static function general(){

        $items = array();

        $items = array_merge($items, Menu::applicationItems([]));
        

        if (!empty($currentUserRoles["admin"])){
            //se l'utente è amministratore
            if(true){
                $items = array_merge($items, Menu::sysAdminItems());
            }
        }
        return $items;
    }

    public static function applicationItems($params){

        return 
        [
            [
                'label' => Yii::t('smartsignage', 'Monitor'),
                'url' => ['/custom/monitor/index'],
                'icon' => 'fontawesome fa fa-desktop',
            ],
            [
                'label' => Yii::t('smartsignage', 'Layout'),
                'url' => ['/custom/layout/index'],
                'icon' => 'fontawesome fa fa-picture-o',
            ],
            [
                'label' => Yii::t('smartsignage', 'Layout Zone'),
                'url' => ['/custom/layout-zone/index'],
                'icon' => 'fontawesome fa fa-th',
            ],
            [
                'label' => Yii::t('smartsignage', 'Preset'),
                'url' => ['/custom/preset/index'],
                'icon' => 'fontawesome fa fa-check',
            ],
            [
                'label' => Yii::t('smartsignage', 'Preset Content'),
                'url' => ['/custom/preset-content/index'],
                'icon' => 'fontawesome fa fa-check-square-o',
            ],            
            [
                'label' => Yii::t('smartsignage', 'Image'),
                'url' => ['/custom/image/index'],
                'icon' => 'fontawesome fa fa-check-square-o',
            ],            
        ];
    }


    public static function sysAdminItems(){
        return [
            [
                'label' => Yii::t('scivac', 'SysAdmin'),
                'icon' => 'fontawesome fa fa-cogs',
                'url' => '#',
                'items' => [
                    [   'label' => Yii::t('scivac', 'Users'),
                        'url' => ['/users/user/index'],
                        'icon' => 'fontawesome fa fa-user',
                    ],
                    [
                        'label' => Yii::t('scivac', 'Users Permissions'),
                        'url' => ['/permissions/auth-item/auth'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [
                        'label' => Yii::t('scivac', 'Users Roles'),
                        'url' => ['/permissions/auth-item/rule'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [   'label' => Yii::t('scivac', 'Options'),
                        'url' => ['/options/option/index'],
                        'icon' => 'fontawesome fa fa-cog'
                    ],
                ]
            ]
        ];
    }

}
