<?php

namespace bitcream\smartsignage\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the dropping of table `{{%preset_id_column_to_preset_content}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%layout}}`
 */
class M210420082600DropPresetIdColumnFromPresetContentTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // drops foreign key for table `{{%layout}}`
        $this->dropForeignKey(
            '{{%fk-preset_content-preset_id}}',
            '{{%preset_content}}'
        );

        // drops index for column `preset_id`
        $this->dropIndex(
            '{{%idx-preset_content-preset_id}}',
            '{{%preset_content}}'
        );

        $this->dropColumn('{{%preset_content}}', 'preset_id');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->addColumn('{{%preset_content}}', 'preset_id', $this->integer()->null());

        // creates index for column `preset_id`
        $this->createIndex(
            '{{%idx-preset_content-preset_id}}',
            '{{%preset_content}}',
            'preset_id'
        );

        // add foreign key for table `{{%layout}}`
        $this->addForeignKey(
            '{{%fk-preset_content-preset_id}}',
            '{{%preset_content}}',
            'preset_id',
            '{{%layout}}',
            'id',
            'CASCADE'
        );
    }
}
