<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $searchModel bitcream\smartsignage\custom\backend\models\PresetSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
bitcream\smartsignage\custom\backend\Asset::register($this);

$this->title = Yii::t('smartsignage', 'Presets');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="preset-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <?php $form = ActiveForm::begin([
        'id' => 'preset-form',
        'class' => 'form-inline',
        'action' => ['create'],
    ]); ?>

    <div class="row">
        <div class="col-md-6 col-xs-6">
            <?= $form->field($model, 'layout_id')->dropDownList(
                ArrayHelper::map($layouts,'id',function ($model) {
                    return $model['name'];
                })
            )->label(Yii::t('smartsignage', 'Layouts'))
            ?>
        </div>
        <div class="col-md-6 col-xs-6">

            <div class="form-group">
                <?= Html::submitButton(Yii::t('smartsignage', 'Create Preset'), ['class' => 'btn btn-success button-inline']) ?>
            </div>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= $this->render('_datatable',[
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
    ]) ?>


</div>
