<?php

namespace bitcream\smartsignage\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%text}}".
 *
 * @property int $id
 * @property string|null $text
 * @property string|null $style
 * @property string|null $animation
 * @property string|null $speed
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 */
class Text extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%text}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['text', 'style'], 'string'],
            [['status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['animation', 'speed', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('smartsignage', 'ID'),
            'text' => Yii::t('smartsignage', 'Text'),
            'style' => Yii::t('smartsignage', 'Style'),
            'animation' => Yii::t('smartsignage', 'Animation'),
            'speed' => Yii::t('smartsignage', 'Speed'),
            'status' => Yii::t('smartsignage', 'Status'),
            'created_at' => Yii::t('smartsignage', 'Created At'),
            'created_user_id' => Yii::t('smartsignage', 'Created User ID'),
            'updated_at' => Yii::t('smartsignage', 'Updated At'),
            'updated_user_id' => Yii::t('smartsignage', 'Updated User ID'),
        ];
    }
}
