<?php

namespace bitcream\smartsignage\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%layout_zone}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%layout}}`
 */
class M210414100137AddLayoutIdColumnToLayoutZoneTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%layout_zone}}', 'layout_id', $this->integer()->null());

        // creates index for column `layout_id`
        $this->createIndex(
            '{{%idx-layout_zone-layout_id}}',
            '{{%layout_zone}}',
            'layout_id'
        );

        // add foreign key for table `{{%layout}}`
        $this->addForeignKey(
            '{{%fk-layout_zone-layout_id}}',
            '{{%layout_zone}}',
            'layout_id',
            '{{%layout}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%layout}}`
        $this->dropForeignKey(
            '{{%fk-layout_zone-layout_id}}',
            '{{%layout_zone}}'
        );

        // drops index for column `layout_id`
        $this->dropIndex(
            '{{%idx-layout_zone-layout_id}}',
            '{{%layout_zone}}'
        );

        $this->dropColumn('{{%layout_zone}}', 'layout_id');
    }
}
