<?php

use yii\helpers\Html;
use yii\widgets\Breadcrumbs;
/* @var $this yii\web\View */
/* @var $searchModel bitcream\smartsignage\custom\backend\models\MonitorSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('smartsignage', 'Monitors');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="monitor-index">
    <?= 
    Breadcrumbs::widget([
        'homeLink' => [ 
                        'label' => Yii::t('yii', 'Dashboard'),
                        'url' => Yii::$app->homeUrl,
                    ],
        'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
    ]) 
    ?>
    <h1><?= Html::encode($this->title) ?></h1>
    
    <p>
        <?= Html::a(Yii::t('smartsignage', 'Create Monitor'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= $this->render('_datatable',[
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
    ]) ?>


</div>
