<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use dosamigos\ckeditor\CKEditor;
use kartik\color\ColorInput;

/* @var $this yii\web\View */
/* @var $model bitcream\smartsignage\custom\backend\models\Text */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="text-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'text')->widget(CKEditor::className(), [
                'options' => ['rows' => 3],
                'preset' => 'custom',
                'clientOptions' => [
                    'height' => 200,
                    'toolbarGroups' => [
                        ['name' => 'basicstyles', 'groups' => ['basicstyles', 'cleanup']],
                        ['name' => 'links', 'groups' => ['links']],
                    ],
                    'removeButtons' => 'Subscript,Superscript,Flash,Table,HorizontalRule,Smiley,SpecialChar,PageBreak,Iframe,Anchor,Strike',
                    'removePlugins' => 'elementspath',
                    'resize_enabled' => false
                ]
            ]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'background_color')->widget(ColorInput::classname(), [
                'options' => ['placeholder' => Yii::t('smartsignage', 'Select background color').' ...'],
            ]); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'text_color')->widget(ColorInput::classname(), [
                'options' => ['placeholder' => Yii::t('smartsignage', 'Select text color').' ...'],
            ]); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'text_size')->textInput() ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'font_family')->textInput() ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'font_weight')->textInput() ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'speed')->textInput() ?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('smartsignage', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
