<?php

namespace bitcream\smartsignage\custom\common\models;

use Yii;
use bitcream\smartsignage\custom\common\behaviors\StatusBehaviors;
use bitcream\smartsignage\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use yii\helpers\ArrayHelper;

/**
 * This is the model class for table "{{%image}}".
 *
 */
class Image extends base\Image
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'image',
                ],
            ],
       ]);
    }

    public function fields(){
        return [
            'content_type' => "contentType",
            'source',
            'fit',
        ];
    }

    public static function getContentType()
    {
        return "image";
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            // each category_id must exist in category table (*1)
            [['image'], 'required'],
            ['image', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
            
        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'image' => Yii::t('smartsignage', 'Image'),
        ]);
    }

}
