<?php

namespace bitcream\smartsignage\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%monitor}}".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $width
 * @property string|null $height
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $base_preset_id
 *
 * @property Preset $basePreset
 */
class Monitor extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%monitor}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id', 'base_preset_id'], 'integer'],
            [['name', 'width', 'height', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['base_preset_id'], 'exist', 'skipOnError' => true, 'targetClass' => Preset::className(), 'targetAttribute' => ['base_preset_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('smartsignage', 'ID'),
            'name' => Yii::t('smartsignage', 'Name'),
            'width' => Yii::t('smartsignage', 'Width'),
            'height' => Yii::t('smartsignage', 'Height'),
            'status' => Yii::t('smartsignage', 'Status'),
            'created_at' => Yii::t('smartsignage', 'Created At'),
            'created_user_id' => Yii::t('smartsignage', 'Created User ID'),
            'updated_at' => Yii::t('smartsignage', 'Updated At'),
            'updated_user_id' => Yii::t('smartsignage', 'Updated User ID'),
            'base_preset_id' => Yii::t('smartsignage', 'Base Preset ID'),
        ];
    }

    /**
     * Gets query for [[BasePreset]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBasePreset()
    {
        return $this->hasOne(Preset::className(), ['id' => 'base_preset_id'])->inverseOf('monitors');
    }
}
