<?php

namespace bitcream\smartsignage\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%preset}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%layout}}`
 */
class M210414103030AddLayoutIdColumnToPresetTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%preset}}', 'layout_id', $this->integer()->null());

        // creates index for column `layout_id`
        $this->createIndex(
            '{{%idx-preset-layout_id}}',
            '{{%preset}}',
            'layout_id'
        );

        // add foreign key for table `{{%layout}}`
        $this->addForeignKey(
            '{{%fk-preset-layout_id}}',
            '{{%preset}}',
            'layout_id',
            '{{%layout}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%layout}}`
        $this->dropForeignKey(
            '{{%fk-preset-layout_id}}',
            '{{%preset}}'
        );

        // drops index for column `layout_id`
        $this->dropIndex(
            '{{%idx-preset-layout_id}}',
            '{{%preset}}'
        );

        $this->dropColumn('{{%preset}}', 'layout_id');
    }
}
