<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model bitcream\smartsignage\custom\common\models\base\Image */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="image-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'image')->widget(floor12\files\components\FileInputWidget::class) ?>
    <input type="hidden" name="source" value="<?=($model->image)? $model->image->href: ""?>">

    <div class="row">
        <div class="col-md-6 col-xs-12">
        <?= $form->field($model, 'fit')->dropDownList([
                'cover' => Yii::t('smartsignage', 'cover'), //value => label
                'contain' => Yii::t('smartsignage', 'contain'), //value => label
            ],
            ['prompt'=>Yii::t('smartsignage', 'Select fit')]
        )
        ?>
        </div>
    </div>
    
    <div class="form-group">
        <?= Html::submitButton(Yii::t('smartsignage', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
