<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model bitcream\smartsignage\custom\common\models\base\Video */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="video-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'video')->widget(floor12\files\components\FileInputWidget::class) ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'muted')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'loop')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'volume')->dropDownList([
                    '1' => '1', 
                    '2' => '2', 
                    '3' => '3', 
                    '4' => '4', 
                    '5' => '5', 
                    '6' => '6', 
                    '7' => '7', 
                    '8' => '8', 
                    '9' => '9', 
                    '10' => '10', 
                ],
                ['prompt'=>Yii::t('smartsignage', 'Select volume')]
            )
            ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
        <?= $form->field($model, 'fit')->dropDownList([
                'cover' => Yii::t('smartsignage', 'cover'), //value => label
                'contain' => Yii::t('smartsignage', 'contain'), //value => label
            ],
            ['prompt'=>Yii::t('smartsignage', 'Select fit')]
        )
        ?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('smartsignage', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
