<?php
namespace bitcream\smartsignage\custom\common\behaviors;

use yii\base\Behavior;
use yii\db\ActiveRecord;
use bitcream\smartsignage\custom\common\utils\Gotify;
use yii\base\Event;

class SendNotification extends Behavior
{
    /**
     * Event for send notification with Gotify
     */
    public function events()
    {
        return [
            ActiveRecord::EVENT_BEFORE_UPDATE => 'sendMessage',
            ActiveRecord::EVENT_AFTER_INSERT => 'sendMessage',
        ];
    }

    public function sendMessage(){
        Gotify::sendMessage($this->owner->id, $this->owner->className());
    }
}