<?php

namespace bitcream\smartsignage\custom\common\models;

use Yii;
use bitcream\smartsignage\custom\common\behaviors\StatusBehaviors;
use bitcream\smartsignage\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;

/**
 * This is the model class for table "{{%preset_content}}".
 *
 */
class PresetContent extends base\PresetContent
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }

    public function getContent()
    {
        return $this->hasOne($this->class, ['id' => 'object_id']);
    }

    public function getClasses()
    {
        return [
            \bitcream\smartsignage\custom\common\models\Image::className() => \bitcream\smartsignage\custom\common\models\Image::getContentType(),
            \bitcream\smartsignage\custom\common\models\Text::className() => \bitcream\smartsignage\custom\common\models\Text::getContentType(),
            //\bitcream\smartsignage\custom\common\models\Audio::className() => \bitcream\smartsignage\custom\common\models\Audio::getContentType(),
            \bitcream\smartsignage\custom\common\models\Video::className() => \bitcream\smartsignage\custom\common\models\Video::getContentType(),
        ];
    }
}
