<?php

namespace bitcream\smartsignage\custom\common\models;

use Yii;
use bitcream\smartsignage\custom\common\behaviors\StatusBehaviors;
use bitcream\smartsignage\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\smartsignage\custom\common\behaviors\SendNotification;

/**
 * This is the model class for table "{{%image}}".
 *
 */
class Text extends base\Text
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'send-notification' => [
                'class' => SendNotification::className(),
            ],
       ]);
    }

    public function fields(){
        return [
            'content_type' => "contentType",
            'text',
            'style'=> function ($model){
                return [
                    'background_color' => $this->background_color,
                    'text_color' => $this->text_color,
                    'text_size' => $this->text_size,
                    'font_family' => $this->font_family,
                    'font_weight' => $this->font_weight,
                ];
            },
            'animation' => function ($model){
                return [
                    'speed' => $this->speed,
                ];
            },
        ];
    }

    public static function getContentType()
    {
        return "text";
    }
}
