<?php

namespace bitcream\smartsignage\custom\api\models;

use Yii;

/**
 * This is the model class for table "{{%layout}}".
 *
 */
class Layout extends \bitcream\smartsignage\custom\common\models\Layout
{
    public function fields(){
        return [
            'width' => function ($model){
                return (int)$this->width;
            },
            'height'=> function ($model){
                return (int)$this->height;
            },
            'zones' => 'layoutZones'
        ];
    }

    /**
     * Gets query for [[LayoutZones]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getLayoutZones()
    {
        return $this->hasMany(LayoutZone::className(), ['layout_id' => 'id'])->inverseOf('layout');
    }
}
