<?php

namespace bitcream\smartsignage\custom\backend\controllers;

use Yii;
use bitcream\smartsignage\custom\backend\models\Video;
use bitcream\smartsignage\custom\backend\models\VideoSearch;
use bitcream\smartsignage\custom\backend\models\PresetContent;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * VideoController implements the CRUD actions for Video model.
 */
class VideoController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Video models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new VideoSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Video model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Video model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($preset)
    {
        $model = new Video();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            if($model->video){
                $model->muted = (isset($model->muted) && $model->muted == 1)? true : false;
                $model->loop = (isset($model->loop) && $model->loop == 1)? true : false;

                $model->source = Yii::$app->params['serverName'].$model->video[1]->href;
                $model->type = "file";
                $model->save(false);
            }
            return $this->redirect(['preset/update?id='.$presetContent->preset_id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Video model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id, $preset)
    {
        $model = $this->findModel($id);
        $model->muted = (isset($model->muted) && $model->muted == 1)? true : false;
        $model->loop = (isset($model->loop) && $model->loop == 1)? true : false;

        if ($model->load(Yii::$app->request->post())) {
            if($model->video){
                $video = $model->video[1];
                $model->source = Yii::$app->params['serverName'].$video->href;
                $model->type = "file";
                $model->save(false);
            }
            $presetContent = PresetContent::setPresetContentObjectId($preset, $model);
            return $this->redirect(['preset/update?id='.$presetContent->preset_id]);
        }else{
            $video = $model->video;
        }

        return $this->render('update', [
            'model' => $model,
            'video' => $video,
        ]);
    }

    /**
     * Deletes an existing Video model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Video model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Video the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Video::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('smartsignage', 'The requested page does not exist.'));
    }
}
