<?php

use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use emberware\evidia\datatable\common\models\DataTableCustom;

/* @var $this yii\web\View */
/* @var $model bitcream\smartsignage\custom\common\models\base\Preset */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="preset-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'name')->textInput() ?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('smartsignage', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

    <hr>

    <h3>Layout: <?=$model->layout->name?></h3>
    <img src = "<?= $model->layout->source ?>" class = "img-responsive">
    <br>
    <?php
        if($layoutZones){
    ?>
        <table class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Zone name</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($layoutZones as $layoutZone){ ?>
                    <tr>
                        <td><?=$layoutZone->zone_name?></td>
                        <td>
                        <?php
                            $html = "";
                            foreach($layoutZone->presetContents as $presetContent){
                                if($presetContent->zone_id == $layoutZone->id && $presetContent->preset_id == $model->id && $presetContent->status >20){
                                    $contentType = $presetContent->class::getContentType();
                                    $html .= $contentType." ";
                                    $html .= Html::a(Yii::t('smartsignage', 'Update content'), [$contentType.'/update','id'=>$presetContent->object_id, 'preset'=> $presetContent->id],['class' => 'btn btn-warning button-inline'])." "
                                    .Html::a(Yii::t('smartsignage','Delete content'), ['preset-content/delete','id'=>$presetContent->id],[
                                        'class' => 'btn btn-danger button-inline',
                                        'data' => [
                                            'confirm' => Yii::t('smartsignage', 'Are you sure you want to delete this content?'),
                                            'method' => 'post',
                                        ]
                                    ]);
                                    break;
                                }
                            }
                            if($html == ""){
                            ?>
                                <?php $form = ActiveForm::begin([
                                    'class' => 'form-inline',
                                    'action' => ['create-content'],
                                ]); ?>
                                <div class="row">
                                    <div class="col-sm-4">
                                        <?= $form->field($modelPresetContent, 'class')->dropDownList($model->classes)->label(false)?>
                                        <input type="hidden" name="preset" value="<?=$model->id?>" />
                                        <input type="hidden" name="zone" value="<?=$layoutZone->id?>" />
                                    </div>
                                    <div class="col-sm-4">
                                        <?= Html::submitButton(Yii::t('smartsignage', 'Add content'), ['class' => 'btn btn-success button-inline']) ?>
                                    </div>
                                </div>
                                <?php ActiveForm::end();
                            }else{
                                echo $html;
                            }

                        ?>
                        </td>
                    </tr>
                    <?php } ?>
            </tbody>
        </table>
    <?php
        }
    ?>
</div>
