<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use emberware\evidia\datatable\common\models\DataTableCustom;

/* @var $this yii\web\View */
/* @var $model bitcream\smartsignage\custom\common\models\base\Slider */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="slider-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'time')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'loop')->checkbox([
                'label' => Yii::t('smartsignage', 'Loop'),
                'checked' => (bool)$model->loop,
                'class' => 'loop',
            ]); ?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('smartsignage', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>
    <hr>
    <?= Html::a(Yii::t('smartsignage', 'Create slide'), ['slides/create', 'slider'=> $model->id, 'preset' => $preset], ['class' => 'btn btn-success']) ?>
    <br>
    <br>
    <div class="datatable">
        <?=
            DataTableCustom::widget([
                'dataProvider' => $dataProvider,
                'id' => 'slides-table',
                //'searchModel' => $searchModel,
                'columns' => [
                    // ['class' => '\yii\grid\SerialColumn'],
                    [   
                        'attribute'=>Yii::t('smartsignage', 'Source'),
                        'format'=>'raw',
                        'value' => function($data) use ($preset)
                        {return Html::a($data->source, ['slides/update','id'=>$data->id, 'preset'=> $preset, 'slider' => $data->id]);}
                    ],
                    [
                        'label' => Yii::t('smartsignage', 'Fit'),
                        'attribute'=>'fit',
                        'value'=>'fit',
                    ],
                    [
                        'label' => Yii::t('smartsignage', 'Slider'),
                        'attribute'=>'slider_id',
                        'value'=>'slider.id',
                    ],
                    [
                        'format'=>'raw',
                        'label' => Yii::t('smartsignage', 'Actions'),
                        'value' => function ($data) use ($preset, $model){
                            return Html::a("<i class='fa fa-trash-o'></i>", ['slides/delete','id'=> $data->id, 'preset'=> $preset, 'slider' => $model->id],[
                                'data' => [
                                    'confirm' => Yii::t('smartsignage', 'Are you sure you want to delete this slide?'),
                                    'method' => 'post',
                                ]
                            ]);
                        }
                    ],
                ],
                'clientOptions' => [
                    "responsive"=>true,
                    "language" => [
                        "url" => Yii::t('smartsignage', "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                    ]
                ]
            ]);
        ?>
    </div>

</div>
