<?php

namespace bitcream\smartsignage\custom\common\models;

use Yii;
use bitcream\smartsignage\custom\common\behaviors\StatusBehaviors;
use bitcream\smartsignage\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use yii\helpers\ArrayHelper;

/**
 * This is the model class for table "{{%audio}}".
 *
 */
class Audio extends base\Audio
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
       ]);
    }

    public function fields(){
        return [
            'content_type' => "contentType",
            'name',
            'url',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            // each category_id must exist in category table (*1)
            [['url'], 'required'],
        ]);
    }

    public static function getContentType()
    {
        return "audio";
    }
}
