<?php

namespace bitcream\smartsignage\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%audio}}".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $url
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 */
class Audio extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%audio}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['name', 'url', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('smartsignage', 'ID'),
            'name' => Yii::t('smartsignage', 'Name'),
            'url' => Yii::t('smartsignage', 'Url'),
            'status' => Yii::t('smartsignage', 'Status'),
            'created_at' => Yii::t('smartsignage', 'Created At'),
            'created_user_id' => Yii::t('smartsignage', 'Created User ID'),
            'updated_at' => Yii::t('smartsignage', 'Updated At'),
            'updated_user_id' => Yii::t('smartsignage', 'Updated User ID'),
        ];
    }
}
