<?php

namespace bitcream\smartsignage\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%monitor}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%preset}}`
 */
class M210416144353AddBasePresetIdColumnToMonitorTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%monitor}}', 'base_preset_id', $this->integer()->null());

        // creates index for column `base_preset_id`
        $this->createIndex(
            '{{%idx-monitor-base_preset_id}}',
            '{{%monitor}}',
            'base_preset_id'
        );

        // add foreign key for table `{{%preset}}`
        $this->addForeignKey(
            '{{%fk-monitor-base_preset_id}}',
            '{{%monitor}}',
            'base_preset_id',
            '{{%preset}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%preset}}`
        $this->dropForeignKey(
            '{{%fk-monitor-base_preset_id}}',
            '{{%monitor}}'
        );

        // drops index for column `base_preset_id`
        $this->dropIndex(
            '{{%idx-monitor-base_preset_id}}',
            '{{%monitor}}'
        );

        $this->dropColumn('{{%monitor}}', 'base_preset_id');
    }
}
