<?php

namespace bitcream\smartsignage\custom\backend\controllers;

use Yii;
use bitcream\smartsignage\custom\backend\models\Slides;
use bitcream\smartsignage\custom\backend\models\SlidesSearch;
use bitcream\smartsignage\custom\backend\models\PresetContent;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * SlidesController implements the CRUD actions for Slides model.
 */
class SlidesController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Slides models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SlidesSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Slides model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Slides model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($slider, $preset)
    {
        $model = new Slides();

        if ($model->load(Yii::$app->request->post())) {
            $model->slider_id = $slider;
            if($model->image){
                $model->source = Yii::$app->params['serverName'].$model->image[1]->href;
                $model->save(false);
            }
            return $this->redirect(['slider/update?id='.$slider.'&preset='.$preset]);
        }

        return $this->render('create', [
            'model' => $model,
            'slider' => $slider,
            'preset' => $preset,
        ]);
    }

    /**
     * Updates an existing Slides model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id, $slider, $preset)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            $model->slider_id = $slider;
            if($model->image){
                $model->source = Yii::$app->params['serverName'].$model->image[1]->href;
                $model->save(false);
            }
            return $this->redirect(['slider/update?id='.$slider.'&preset='.$preset]);
        }

        return $this->render('update', [
            'model' => $model,
            'slider' => $slider,
            'preset' => $preset,
        ]);
    }

    /**
     * Deletes an existing Slides model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id, $preset, $slider)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['slider/update?id='.$slider.'&preset='.$preset]);
    }

    /**
     * Finds the Slides model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slides the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Slides::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('smartsignage', 'The requested page does not exist.'));
    }
}
