<?php

use yii\helpers\Html;
use yii\widgets\Breadcrumbs;

/* @var $this yii\web\View */
/* @var $model bitcream\smartsignage\custom\common\models\base\Image */

$this->title = Yii::t('smartsignage', 'Update Image: {name}', [
    'name' => $model->id,
]);
$this->params['breadcrumbs'][] = ['label' => Yii::t('smartsignage', 'Presets'), 'url' => ['preset/index']];
$this->params['breadcrumbs'][] = Yii::t('smartsignage', 'Image');
?>
<div class="image-update">
    <?= 
    Breadcrumbs::widget([
        'homeLink' => [ 
                        'label' => Yii::t('yii', 'Dashboard'),
                        'url' => Yii::$app->homeUrl,
                    ],
        'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
    ]) 
    ?>
    <h1><?= Html::encode($this->title) ?></h1>

    <?= $this->render('_form', [
        'model' => $model,
        'image' => $image,
    ]) ?>

</div>
