<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
/* @var $this yii\web\View */
/* @var $model bitcream\smartsignage\custom\common\models\base\PresetContent */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="preset-content-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'preset_id')->dropDownList(
                ArrayHelper::map($presets,'id',function ($model) {
                    return $model['name'];
                })
            )->label(Yii::t('smartsignage', 'Preset'))
            ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'zone_id')->dropDownList(
                ArrayHelper::map($zone,'id',function ($model) {
                    return $model['zone_name'];
                })
            )->label(Yii::t('smartsignage', 'Layout zone'))
            ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'class')->dropDownList($model->classes)->label(Yii::t('smartsignage', 'Class'))
            ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'object_id')->dropDownList(
                ArrayHelper::map($objects,'id',function ($model) {
                    return $model['id'];
                })
            )->label(Yii::t('smartsignage', 'Object'))
            ?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('smartsignage', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
