<?php

namespace bitcream\smartsignage\custom\common\models;

use Yii;
use bitcream\smartsignage\custom\common\behaviors\StatusBehaviors;
use bitcream\smartsignage\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use yii\helpers\ArrayHelper;

/**
 * This is the model class for table "{{%layout}}".
 *
 */
class Layout extends base\Layout
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'image',
                ],
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
       ]);
    }

     /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            // each category_id must exist in category table (*1)
            ['image', 'file', 'extensions' => ['jpg', 'gif', 'png'], 'maxFiles' => 1],

        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'image' => Yii::t('smartsignage', 'Image'),
        ]);
    }

    public static function findAllActive(){
        return Layout::find()->where(['status' => '30'])->all();
    }
}
