<?php

namespace bitcream\smartsignage\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "preset".
 *
 * @property int $id
 * @property string|null $name
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $layout_id
 * @property int|null $audio_id
 *
 * @property Monitor[] $monitors
 * @property Audio $audio
 * @property Layout $layout
 * @property PresetContent[] $presetContents
 */
class Preset extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'preset';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id', 'layout_id', 'audio_id'], 'integer'],
            [['name', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['audio_id'], 'exist', 'skipOnError' => true, 'targetClass' => Audio::className(), 'targetAttribute' => ['audio_id' => 'id']],
            [['layout_id'], 'exist', 'skipOnError' => true, 'targetClass' => Layout::className(), 'targetAttribute' => ['layout_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('smartsignage', 'ID'),
            'name' => Yii::t('smartsignage', 'Name'),
            'status' => Yii::t('smartsignage', 'Status'),
            'created_at' => Yii::t('smartsignage', 'Created At'),
            'created_user_id' => Yii::t('smartsignage', 'Created User ID'),
            'updated_at' => Yii::t('smartsignage', 'Updated At'),
            'updated_user_id' => Yii::t('smartsignage', 'Updated User ID'),
            'layout_id' => Yii::t('smartsignage', 'Layout ID'),
            'audio_id' => Yii::t('smartsignage', 'Audio ID'),
        ];
    }

    /**
     * Gets query for [[Monitors]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMonitors()
    {
        return $this->hasMany(Monitor::className(), ['base_preset_id' => 'id'])->inverseOf('basePreset');
    }

    /**
     * Gets query for [[Audio]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAudio()
    {
        return $this->hasOne(Audio::className(), ['id' => 'audio_id'])->inverseOf('presets');
    }

    /**
     * Gets query for [[Layout]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getLayout()
    {
        return $this->hasOne(Layout::className(), ['id' => 'layout_id'])->inverseOf('presets');
    }

    /**
     * Gets query for [[PresetContents]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPresetContents()
    {
        return $this->hasMany(PresetContent::className(), ['preset_id' => 'id'])->inverseOf('preset');
    }
}
