<?php

namespace bitcream\smartsignage\custom\common\utils;
use Yii;

/**
 * This is the class for create menu left
 */
class Menu
{

    public static function general(){

        $items = array();

        $currentUserId = Yii::$app->user->id;
        $currentUserRoles = Yii::$app->authManager->getRolesByUser($currentUserId);

        if (!empty($currentUserRoles["monitorManager"]) || !empty($currentUserRoles["admin"])){
            //se l'utente è amministratore
            if(true){
                $items = array_merge($items, Menu::applicationItems([]));
            }
        }

        if (!empty($currentUserRoles["admin"])){
            //se l'utente è amministratore
            if(true){
                $items = array_merge($items, Menu::sysAdminItems());
            }
        }

        return $items;
    }

    public static function applicationItems($params){

        return
        [
            [
                'label' => Yii::t('smartsignage', 'Monitor'),
                'url' => ['/custom/monitor/index'],
                'icon' => 'fontawesome fa fa-desktop',
            ],
            [
                'label' => Yii::t('smartsignage', 'Preset'),
                'url' => ['/custom/preset/index'],
                'icon' => 'fontawesome fa fa-check',
            ],
        ];
    }


    public static function sysAdminItems(){
        return [
            [
                'label' => Yii::t('smartsignage', 'SysAdmin'),
                'icon' => 'fontawesome fa fa-cogs',
                'url' => '#',
                'items' => [
                    [
                        'label' => Yii::t('smartsignage', 'Audio'),
                        'url' => ['/custom/audio/index'],
                        'icon' => 'fontawesome fa fa-volume-up',
                    ],
                    [
                        'label' => Yii::t('smartsignage', 'Layout'),
                        'url' => ['/custom/layout/index'],
                        'icon' => 'fontawesome fa fa-table',
                    ],
                    [
                        'label' => Yii::t('smartsignage', 'Layout Zone'),
                        'url' => ['/custom/layout-zone/index'],
                        'icon' => 'fontawesome fa fa-th',
                    ],
                    [   'label' => Yii::t('smartsignage', 'Users'),
                        'url' => ['/users/user/index'],
                        'icon' => 'fontawesome fa fa-user',
                    ],
                    [
                        'label' => Yii::t('smartsignage', 'Users Permissions'),
                        'url' => ['/permissions/auth-item/auth'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [
                        'label' => Yii::t('smartsignage', 'Users Roles'),
                        'url' => ['/permissions/auth-item/rule'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [   'label' => Yii::t('smartsignage', 'Options'),
                        'url' => ['/options/option/index'],
                        'icon' => 'fontawesome fa fa-cog'
                    ],
                ]
            ]
        ];
    }

}
