<?php

namespace bitcream\smartsignage\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%slides}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%slides}}`
 */
class M210603132539AddSliderIdColumnToSlidesTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%slides}}', 'slider_id', $this->integer()->null());

        // creates index for column `slider_id`
        $this->createIndex(
            '{{%idx-slides-slider_id}}',
            '{{%slides}}',
            'slider_id'
        );

        // add foreign key for table `{{%slides}}`
        $this->addForeignKey(
            '{{%fk-slides-slider_id}}',
            '{{%slides}}',
            'slider_id',
            '{{%slides}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%slides}}`
        $this->dropForeignKey(
            '{{%fk-slides-slider_id}}',
            '{{%slides}}'
        );

        // drops index for column `slider_id`
        $this->dropIndex(
            '{{%idx-slides-slider_id}}',
            '{{%slides}}'
        );

        $this->dropColumn('{{%slides}}', 'slider_id');
    }
}
