<?php

namespace bitcream\smartsignage\custom\api\models;

use Yii;
use bitcream\smartsignage\custom\api\models\Layout;
use bitcream\smartsignage\custom\api\models\PresetContent;

/**
 * This is the model class for table "{{%preset}}".
 *
 */
class Preset extends \bitcream\smartsignage\custom\common\models\Preset
{
    public function fields(){
        return [
            "layout",
            "audio_bg" => "audio",
            "visual_content" => "presetContents",
        ];
    }

    /**
     * Gets query for [[Layout]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getLayout()
    {
        return $this->hasOne(Layout::className(), ['id' => 'layout_id'])->inverseOf('presets');
    }

    /**
     * Gets query for [[Layout]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPresetContents()
    {
        return $this->hasMany(PresetContent::className(), ['preset_id' => 'id'])->inverseOf('preset');
    }

    /**
     * Gets query for [[Audio]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAudio()
    {
        return $this->hasOne(Audio::className(), ['id' => 'audio_id'])->inverseOf('presets');
    }
}
