<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model bitcream\smartsignage\custom\common\models\base\Monitor */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="monitor-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'name')->textInput() ?>
        </div>
    </div>

    <!-- <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'width')->textInput() ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'height')->textInput() ?>
        </div>
    </div> -->
    <?php if($model->id){ ?>
        <div class="row">
            <div class="col-md-6 col-xs-12">
                <?= $form->field($model, 'base_preset_id')->dropDownList(
                    ArrayHelper::map($presets,'id',function ($model) {
                        return $model['name'];
                    }),
                    ['prompt'=>Yii::t('smartsignage', 'Select Preset')]
                )->label(Yii::t('smartsignage', 'Base preset'))
                ?>
            </div>
        </div>
        <p>or</p>    
        <?= Html::a('Create Preset', ['/custom/preset/create', 'monitor' => $model->id], ['class'=>'btn btn-primary grid-button']) ?>
        <br><br><br>
    <?php } ?>
    
    <div class="form-group">
        <?= Html::submitButton(Yii::t('smartsignage', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
