<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model bitcream\smartsignage\custom\common\models\base\Monitor */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="preset-create-form">

<?php $form = ActiveForm::begin([
        'id' => 'preset-form',
        'class' => 'form-inline',
        'action' => ['create', 'monitor'=> $monitor],
    ]); ?>

    <div class="row">
        <?php foreach($layouts as $layout){ ?>
            <div class="col-md-3 col-sm-4 col-xs-6">
                <input type="radio" id="layout-<?=$layout->id?>" name="layout" value="<?= $layout->id; ?>">
                <label for="layout-<?=$layout->id?>">    
                    <?= $layout->name; ?>
                    <img src = "<?= $layout->source ?>" class = "img-responsive">
                </label>              
            </div>
        <?php } ?>
    </div>
    <input type="hidden" name="monitor" value="<?=$monitor?>">
    <div class="row">
        <div class="col-md-6 col-xs-6">
            <div class="form-group">
                <?= Html::submitButton(Yii::t('smartsignage', 'Save Preset'), ['class' => 'btn btn-success button-inline']) ?>
            </div>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>
