<?php

namespace bitcream\smartsignage\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%slider}}".
 *
 * @property int $id
 * @property string|null $time
 * @property int|null $loop
 * @property string|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 */
class Slider extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%slider}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['loop', 'created_user_id', 'updated_user_id'], 'integer'],
            [['time', 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('smartsignage', 'ID'),
            'time' => Yii::t('smartsignage', 'Time'),
            'loop' => Yii::t('smartsignage', 'Loop'),
            'status' => Yii::t('smartsignage', 'Status'),
            'created_at' => Yii::t('smartsignage', 'Created At'),
            'created_user_id' => Yii::t('smartsignage', 'Created User ID'),
            'updated_at' => Yii::t('smartsignage', 'Updated At'),
            'updated_user_id' => Yii::t('smartsignage', 'Updated User ID'),
        ];
    }
}
