<?php

namespace bitcream\smartsignage\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%text}}".
 *
 * @property int $id
 * @property string|null $text
 * @property int|null $speed
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property string|null $background_color
 * @property string|null $text_color
 * @property string|null $text_size
 * @property string|null $font_family
 * @property string|null $font_weight
 */
class Text extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%text}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['text'], 'string'],
            [['speed', 'status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['created_at', 'updated_at', 'background_color', 'text_color', 'text_size', 'font_family', 'font_weight'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('smartsignage', 'ID'),
            'text' => Yii::t('smartsignage', 'Text'),
            'speed' => Yii::t('smartsignage', 'Speed'),
            'status' => Yii::t('smartsignage', 'Status'),
            'created_at' => Yii::t('smartsignage', 'Created At'),
            'created_user_id' => Yii::t('smartsignage', 'Created User ID'),
            'updated_at' => Yii::t('smartsignage', 'Updated At'),
            'updated_user_id' => Yii::t('smartsignage', 'Updated User ID'),
            'background_color' => Yii::t('smartsignage', 'Background Color'),
            'text_color' => Yii::t('smartsignage', 'Text Color'),
            'text_size' => Yii::t('smartsignage', 'Text Size'),
            'font_family' => Yii::t('smartsignage', 'Font Family'),
            'font_weight' => Yii::t('smartsignage', 'Font Weight'),
        ];
    }
}
