<?php

namespace bitcream\smartsignage\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "video".
 *
 * @property int $id
 * @property string|null $type
 * @property string|null $source
 * @property string|null $volume
 * @property string|null $fit
 * @property string|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $muted
 * @property int|null $loop
 */
class Video extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'video';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['created_user_id', 'updated_user_id', 'muted', 'loop'], 'integer'],
            [['type', 'source', 'volume', 'fit', 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('smartsignage', 'ID'),
            'type' => Yii::t('smartsignage', 'Type'),
            'source' => Yii::t('smartsignage', 'Source'),
            'volume' => Yii::t('smartsignage', 'Volume'),
            'fit' => Yii::t('smartsignage', 'Fit'),
            'status' => Yii::t('smartsignage', 'Status'),
            'created_at' => Yii::t('smartsignage', 'Created At'),
            'created_user_id' => Yii::t('smartsignage', 'Created User ID'),
            'updated_at' => Yii::t('smartsignage', 'Updated At'),
            'updated_user_id' => Yii::t('smartsignage', 'Updated User ID'),
            'muted' => Yii::t('smartsignage', 'Muted'),
            'loop' => Yii::t('smartsignage', 'Loop'),
        ];
    }
}
