<?php

namespace bitcream\smartsignage\custom\common\utils;
use Yii;

/**
 * This is the class for create menu left
 */
class Gotify
{
    /**
     * Function for send notification message to Gotify
     */
    public static function sendMessage($id, $class){

        $data = Gotify::getParams($id, $class);
        $data_string = json_encode($data);           
        
        $urlPost = Yii::$app->params['gotifyServer']."/message?token=".Yii::$app->params['tokenApp'];
        
        $headers = [
            "Content-Type: application/json; charset=utf-8"
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $urlPost);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true );
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        
        $result = curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
        curl_close ($ch);
    }

    public static function getLayout($id){
        $apiModel = \bitcream\smartsignage\custom\api\models\Monitor::findOne($id);
        $layout = Yii::createObject('yii\rest\Serializer')->serialize($apiModel);

        return $layout;
    }

    public static function getParams($id, $class){      

        switch($class){
            case 'bitcream\smartsignage\custom\backend\models\Monitor':
                $title = "Set preset";
                $message = "Set layout on monitor ".$id;
                break;
            case 'bitcream\smartsignage\custom\backend\models\Image':
                $title = "Set image";
                $message = "Set image on monitor".$id;
                break;
            case 'bitcream\smartsignage\custom\backend\models\Video':
                $title = "Set video";
                $message = "Set video on monitor".$id;
                break;
            case 'bitcream\smartsignage\custom\backend\models\Text':
                $title = "Set text";
                $message = "Set text on monitor".$id;
                break;
            default:
                return false;
                break;
        }
        
        $data = [
            "title"=>   $title,
            "message"=> $message,
            "priority"=> 1,
        ];

        $extraParams = Gotify::getExtraParams($id);
        if(!$extraParams) return false;

        $data = array_merge($data, $extraParams);

        return $data;
    }

    public static function getExtraParams($id){
        $extraParams = [
            "extras" => [
                "monitor_id" => $id,
                "layout" => Gotify::getLayout($id),
            ],
        ];

        return $extraParams;
    }
    
}