<?php

namespace bitcream\smartsignage\custom\console\controllers;

use Yii;
use yii\console\Controller;
use yii\console\ExitCode;

/**
 * Manage users module permissions
 */
class RbacController extends Controller
{
    public $defaultAction ="init";

   /**
     * Init users permissions and assign the permissions to role
     */

    public function actionInit()
    {

        $auth = Yii::$app->authManager;

        $monitorManager = $auth->getRole('monitorManager');
        if( empty($monitorManager)){
            $monitorManager = $auth->createRole('monitorManager');
            $monitorManager->description = 'ruolo monitor manager';
            $auth->add($monitorManager);
        }

        // add "viewMonitorManager" permission
        $viewMonitorManager = $auth->getPermission('viewMonitorManager');
        if( empty($viewMonitorManager)){
            $viewMonitorManager = $auth->createPermission('viewMonitorManager');
            $viewMonitorManager->description = 'vista monitor manager';
            $auth->add($viewMonitorManager);
        };

        $adminRole = $auth->getRole('admin');
        if($adminRole){
            if(!$auth->hasChild($adminRole, $viewMonitorManager)){
                $auth->addChild($adminRole, $viewMonitorManager);
            }
        };

        $monitorManagerRole = $auth->getRole('monitorManager');
        if($monitorManagerRole){
            if(!$auth->hasChild($monitorManagerRole, $viewMonitorManager)){
                $auth->addChild($monitorManagerRole, $viewMonitorManager);
            }
        };

        return ExitCode::OK;
    }

}
