<?php

namespace bitcream\smartsignage\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%preset_content}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%layout_zone}}`
 */
class M210419121706AddZoneIdColumnToPresetContentTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%preset_content}}', 'zone_id', $this->integer()->null());

        // creates index for column `zone_id`
        $this->createIndex(
            '{{%idx-preset_content-zone_id}}',
            '{{%preset_content}}',
            'zone_id'
        );

        // add foreign key for table `{{%layout_zone}}`
        $this->addForeignKey(
            '{{%fk-preset_content-zone_id}}',
            '{{%preset_content}}',
            'zone_id',
            '{{%layout_zone}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%layout_zone}}`
        $this->dropForeignKey(
            '{{%fk-preset_content-zone_id}}',
            '{{%preset_content}}'
        );

        // drops index for column `zone_id`
        $this->dropIndex(
            '{{%idx-preset_content-zone_id}}',
            '{{%preset_content}}'
        );

        $this->dropColumn('{{%preset_content}}', 'zone_id');
    }
}
