<?php

namespace bitcream\smartsignage\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%preset}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%audio}}`
 */
class M210610085231AddAudioIdColumnToPresetTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%preset}}', 'audio_id', $this->integer()->null());

        // creates index for column `audio_id`
        $this->createIndex(
            '{{%idx-preset-audio_id}}',
            '{{%preset}}',
            'audio_id'
        );

        // add foreign key for table `{{%audio}}`
        $this->addForeignKey(
            '{{%fk-preset-audio_id}}',
            '{{%preset}}',
            'audio_id',
            '{{%audio}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%audio}}`
        $this->dropForeignKey(
            '{{%fk-preset-audio_id}}',
            '{{%preset}}'
        );

        // drops index for column `audio_id`
        $this->dropIndex(
            '{{%idx-preset-audio_id}}',
            '{{%preset}}'
        );

        $this->dropColumn('{{%preset}}', 'audio_id');
    }
}
