<?php

namespace bitcream\smartsignage\custom\backend\controllers;

use bitcream\smartsignage\custom\backend\models\Audio;
use Yii;
use bitcream\smartsignage\custom\backend\models\Preset;
use bitcream\smartsignage\custom\backend\models\PresetSearch;
use bitcream\smartsignage\custom\backend\models\Layout;
use bitcream\smartsignage\custom\backend\models\LayoutZone;
use bitcream\smartsignage\custom\backend\models\PresetContent;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use bitcream\smartsignage\custom\common\utils\Gotify;
use yii\filters\AccessControl;

/**
 * PresetController implements the CRUD actions for Preset model.
 */
class PresetController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Preset models.
     * @return mixed
     */
    public function actionIndex()
    {
        $model = new Preset();
        $searchModel = new PresetSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        $layouts = Layout::find()->all();

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'layouts' => $layouts,
            'model' => $model,
        ]);
    }

    /**
     * Displays a single Preset model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Preset model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($monitor)
    {
        $model = new Preset();
        $layouts = Layout::findAllActive();

        $audio = Audio::find()->where(['>=', 'status', 20])->all();


        if (Yii::$app->request->post() && $model->save()) {
            $model->layout_id = Yii::$app->request->post()["layout"];
            $model->name = "Preset title - ".$model->id;
            $model->save();
            return $this->redirect(['update', 'id' => $model->id, 'monitor' => $monitor]);
        }
        return $this->render('create', [
            'model' => $model,
            'layouts' => $layouts,
            'monitor' => $monitor,
            'audio' => $audio,
        ]);

    }

    /**
     * Updates an existing Preset model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id, $monitor)
    {
        $arrPresetContent = array();
        $model = $this->findModel($id);
        $modelPresetContent = new PresetContent();
        $audio = Audio::find()->where(['>=', 'status', 20])->all();

        $layoutZones = $model->layout->layoutZones;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            if($monitor == false){
                return $this->redirect(['update', 'id' => $model->id, 'monitor' => $monitor]);
            }else{
                return $this->redirect(['monitor/update', 'id' => $monitor]);
            }
        }

        return $this->render('update', [
            'model' => $model,
            'layoutZones' => $layoutZones,
            'modelPresetContent' => $modelPresetContent,
            'monitor' => $monitor,
            'audio' => $audio,
            'preset' => $model->id,

        ]);
    }

    /**
     * Deletes an existing Preset model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();
        PresetContent::deleteContentType($id);
        PresetContent::deleteAll(['preset_id' => $id]);

        return $this->redirect(['index']);
    }


    /**
     * Creates a new Preset-content
     * @return mixed
     */
    public function actionCreateContent()
    {
        $model = new PresetContent();
        $request = Yii::$app->request->post();

        if ($model->load(Yii::$app->request->post())) {

            $presetContentOnZone = $model->checkPresetContentOnZone($request['zone'], $request['preset']);

            if($presetContentOnZone == false){
                $contentType = $request['PresetContent']['class']::getContentType();
                $contentModel = new $request['PresetContent']['class'];
                $contentModel->scenario = $request['PresetContent']['class']::SCENARIO_CREATE_CONTENT;
                $contentModel->save();

                $model->class = $request['PresetContent']['class'];
                $model->zone_id = $request['zone'];
                $model->preset_id = $request['preset'];
                $model->object_id = $contentModel->id;
                $model->save();

                return $this->redirect([$contentType.'/update?id='.$contentModel->id."&preset=".$model->id]);
            }else{
                $contentType = $presetContentOnZone->class::getContentType();
                return $this->redirect([$contentType.'/update?id='.$presetContentOnZone->content->id."&preset=".$presetContentOnZone->id]);
            }
        }
    }

    /**
     * Finds the Preset model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Preset the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Preset::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('smartsignage', 'The requested page does not exist.'));
    }
}
