<?php

use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'monitor-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('smartsignage', 'Preset'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->preset->name, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                'zone.zone_name',
                'class',
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('smartsignage', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('smartsignage',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>