<?php
namespace bitcream\smartsignage\custom\common\behaviors;

use yii\base\Behavior;
use yii\db\ActiveRecord;
use bitcream\smartsignage\custom\common\utils\Gotify;
use bitcream\smartsignage\custom\backend\models\PresetContent;
use yii\base\Event;

class SendNotification extends Behavior
{
    /**
     * Event for send notification with Gotify
     */
    public function events()
    {
        return [
            ActiveRecord::EVENT_AFTER_UPDATE => 'sendMessage',
            ActiveRecord::EVENT_AFTER_INSERT => 'sendMessage',
        ];
    }

    public function sendMessage(){
        if($this->owner->className() != 'bitcream\smartsignage\custom\backend\models\Monitor'){
            if(isset($_GET['preset'])){
                $presetContent = PresetContent::findOne($_GET['preset']);
                $monitors = $presetContent->preset->monitors;
                foreach($monitors as $monitor){
                    Gotify::sendMessage($monitor->id, 'bitcream\smartsignage\custom\backend\models\Monitor');
                }
            }
        }else{
            Gotify::sendMessage($this->owner->id, $this->owner->className());
        }
    }
}