<?php

namespace bitcream\smartsignage\custom\common\models;

use Yii;
use bitcream\smartsignage\custom\common\behaviors\StatusBehaviors;
use bitcream\smartsignage\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\smartsignage\custom\common\behaviors\SendNotification;
use yii\helpers\ArrayHelper;


/**
 * This is the model class for table "{{%image}}".
 *
 */
class Slider extends base\Slider
{
    const SCENARIO_CREATE_CONTENT = 'CREATE_CONTENT';
    const SCENARIO_UPDATE_CONTENT = 'UPDATE_CONTENT';
    
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'send-notification' => [
                'class' => SendNotification::className(),
            ],
       ]);
    }

    public function scenarios()
    {
        $scenarios = parent::scenarios();
        $scenarios[self::SCENARIO_CREATE_CONTENT] = ['status', 'created_user_id', 'updated_user_id', 'created_at', 'updated_at'];
        return $scenarios;
    }

    public function fields(){
        return [
            "content_type" => "contentType",
            "slides" => "slides",
            "time" => function ($model){
                return (int)$this->time;
            },
            "loop" => function ($model){
                return (bool)$this->loop;
            },
        ];
    }

    public static function getContentType()
    {
        return "slider";
    }

    /**
     * Gets query for [[Slides]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSlides()
    {
        return $this->hasMany(Slides::className(), ['slider_id' => 'id'])->inverseOf('slider');
    }

    public static function find(){
        return parent::find()->where([
            'status' => 30, //prodotti non cancellati
        ]);
    }
}
