<?php

namespace bitcream\smartsignage\custom\common\models;

use Yii;
use bitcream\smartsignage\custom\common\behaviors\StatusBehaviors;
use bitcream\smartsignage\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\smartsignage\custom\common\behaviors\SendNotification;
use yii\helpers\ArrayHelper;


/**
 * This is the model class for table "{{%image}}".
 *
 */
class Text extends base\Text
{
    const SCENARIO_CREATE_CONTENT = 'CREATE_CONTENT';
    const SCENARIO_UPDATE_CONTENT = 'UPDATE_CONTENT';
    
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'send-notification' => [
                'class' => SendNotification::className(),
            ],
       ]);
    }

    public function scenarios()
    {
        $scenarios = parent::scenarios();
        $scenarios[self::SCENARIO_CREATE_CONTENT] = ['status', 'created_user_id', 'updated_user_id', 'created_at', 'updated_at'];
        return $scenarios;
    }

    public function fields(){
        return [
            'content_type' => "contentType",
            'text',
            'style'=> function ($model){
                return [
                    'background_color' => $this->background_color,
                    'text_color' => $this->text_color,
                    'text_size' => $this->text_size,
                    'font_family' => $this->font_family,
                    'font_weight' => $this->font_weight,
                ];
            },
            'animation' => function ($model){
                return [
                    'speed' => $this->speed,
                ];
            },
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            [['text', 'speed'],'required', 'on' => self::SCENARIO_UPDATE_CONTENT],

        ]);
    }

    public static function getContentType()
    {
        return "text";
    }

    public static function find(){
        return parent::find()->where([
            'status' => 30, //prodotti non cancellati
        ]);
    }
}
