<?php

namespace bitcream\smartsignage\custom\common\models;

use Yii;
use bitcream\smartsignage\custom\common\behaviors\StatusBehaviors;
use bitcream\smartsignage\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use yii\helpers\ArrayHelper;
use bitcream\smartsignage\custom\common\behaviors\SendNotification;

/**
 * This is the model class for table "{{%video}}".
 *
 */
class Video extends base\Video
{
    const SCENARIO_CREATE_CONTENT = 'CREATE_CONTENT';
    const SCENARIO_UPDATE_CONTENT = 'UPDATE_CONTENT';

    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'video',
                ],
            ],
            'send-notification' => [
                'class' => SendNotification::className(),
            ],
       ]);
    }

    public function scenarios()
    {
        $scenarios = parent::scenarios();
        $scenarios[self::SCENARIO_CREATE_CONTENT] = ['status', 'created_user_id', 'updated_user_id', 'created_at', 'updated_at'];
        return $scenarios;
    }

    public function fields(){
        return [
            'content_type' => "contentType",
            'source_type' => 'type',
            'source',
            'muted',
            'loop',
            'volume' => function ($model){
                return (int)$this->volume;
            },
            'fit',
        ];
    }

    public static function getContentType()
    {
        return "video";
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            // each category_id must exist in category table (*1)
            [['video', 'type', 'source', 'volume', 'fit'], 'required', 'on' => self::SCENARIO_UPDATE_CONTENT],
            ['video', 'file', 'extensions' => ['mp4'], 'maxFiles' => 1],

        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'video' => Yii::t('smartsignage', 'Video'),
        ]);
    }

    public static function find(){
        return parent::find()->where([
            'status' => 30, //prodotti non cancellati
        ]);
    }
}
