<?php

namespace bitcream\smartsignage\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%layout_zone}}".
 *
 * @property int $id
 * @property string|null $zone_name
 * @property string|null $coord_x
 * @property string|null $coord_y
 * @property string|null $size_width
 * @property string|null $size_height
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $layout_id
 *
 * @property Layout $layout
 */
class LayoutZone extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%layout_zone}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['zone_name', 'coord_x', 'coord_y', 'size_width', 'size_height', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['layout_id'], 'exist', 'skipOnError' => true, 'targetClass' => Layout::className(), 'targetAttribute' => ['layout_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('smartsignage', 'ID'),
            'zone_name' => Yii::t('smartsignage', 'Zone Name'),
            'coord_x' => Yii::t('smartsignage', 'Coord X'),
            'coord_y' => Yii::t('smartsignage', 'Coord Y'),
            'size_width' => Yii::t('smartsignage', 'Size Width'),
            'size_height' => Yii::t('smartsignage', 'Size Height'),
            'status' => Yii::t('smartsignage', 'Status'),
            'created_at' => Yii::t('smartsignage', 'Created At'),
            'created_user_id' => Yii::t('smartsignage', 'Created User ID'),
            'updated_at' => Yii::t('smartsignage', 'Updated At'),
            'updated_user_id' => Yii::t('smartsignage', 'Updated User ID'),
            'layout_id' => Yii::t('smartsignage', 'Layout ID'),
        ];
    }

    /**
     * Gets query for [[Layout]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getLayout()
    {
        return $this->hasOne(Layout::className(), ['id' => 'layout_id'])->inverseOf('layoutZones');
    }

    /**
     * Gets query for [[PresetContents]].
     *
     * @return \yii\db\ActiveQuery|yii\db\ActiveQuery
     */
    public function getPresetContents()
    {
        return $this->hasMany(PresetContent::className(), ['zone_id' => 'id'])->inverseOf('zone');
    }
}
