<?php

namespace bitcream\smartsignage\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%preset_content}}".
 *
 * @property int $id
 * @property string|null $zone_name
 * @property int|null $status
 * @property string|null $class
 * @property int|null $object_id
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $zone_id
 * @property int|null $preset_id
 *
 * @property Preset $preset
 * @property LayoutZone $zone
 */
class PresetContent extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%preset_content}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'object_id', 'created_user_id', 'updated_user_id', 'zone_id', 'preset_id'], 'integer'],
            [['zone_name', 'class', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['preset_id'], 'exist', 'skipOnError' => true, 'targetClass' => Preset::className(), 'targetAttribute' => ['preset_id' => 'id']],
            [['zone_id'], 'exist', 'skipOnError' => true, 'targetClass' => LayoutZone::className(), 'targetAttribute' => ['zone_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('smartsignage', 'ID'),
            'zone_name' => Yii::t('smartsignage', 'Zone Name'),
            'status' => Yii::t('smartsignage', 'Status'),
            'class' => Yii::t('smartsignage', 'Class'),
            'object_id' => Yii::t('smartsignage', 'Object ID'),
            'created_at' => Yii::t('smartsignage', 'Created At'),
            'created_user_id' => Yii::t('smartsignage', 'Created User ID'),
            'updated_at' => Yii::t('smartsignage', 'Updated At'),
            'updated_user_id' => Yii::t('smartsignage', 'Updated User ID'),
            'zone_id' => Yii::t('smartsignage', 'Zone ID'),
            'preset_id' => Yii::t('smartsignage', 'Preset ID'),
        ];
    }

    /**
     * Gets query for [[Preset]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPreset()
    {
        return $this->hasOne(Preset::className(), ['id' => 'preset_id'])->inverseOf('presetContents');
    }

    /**
     * Gets query for [[Zone]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getZone()
    {
        return $this->hasOne(LayoutZone::className(), ['id' => 'zone_id'])->inverseOf('presetContents');
    }
}
